/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.VerifyException;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.serviceaction.repair.effectors.VerifyUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SystemLevelVerify
implements Effector {
    private static final String TRACE_MASKT = "XRVXSLVT";
    private static final String TRACE_MASKF = "XRVXSLVF";
    private static final String TRACE_MASKD = "XRVXSLVD";

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> SystemLevelVerify.fire");
        try {
            Map userData = context.getUserData();
            List fruList = (List)userData.get("SELECTED_FRUS");
            Iterator it = fruList.iterator();
            try {
                while (it.hasNext()) {
                    ServiceableElement se = (ServiceableElement)it.next();
                    se.systemLevelVerify(userData);
                }
                VerifyUtils.defaultVerify(userData);
            }
            catch (VerifyException e) {
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(VerifyUtils.evaluateException(userData, e));
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! SystemLevelVerify.fire exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (!(e instanceof EffectorException)) {
                throw new EffectorException(e);
            }
            throw (EffectorException)e;
        }
        Trace.trace(TRACE_MASKT, "<- SystemLevelVerify.fire");
    }
}

